{ **************************************************************************
  ***********          ANDROID'S SIM CARD EMULATOR V2.9        *************
  ***********   TO BE COMPILED WITH TURBO PASCAL 6.0 FOR DOS   *************
  ********  THANK'S TO MOTOROLA FOR MADE SOOO! EASY ENTER TEST MODE ********
  ********  NOW EMULATES A CLONE CARD CAPTURING FRAMES FROM IT  ************
  ********  NOW CAN RUN TEST MODE IN A DCS 1800 MOTOROLA PHONE  ************
  ************************************************************************** }

program ASIMV;   { 25-11-97 V2.9 }
uses crt,dos;

type cad2=string[2];
     cad4=string[4];

CONST

   NAM: array [1..41] of word=($2FE2,$6F05,$6F07,$6F10,$6F11,$6F13,$6F14,$6F15,
                               $6F16,$6F20,$6F25,$6F30,$6F31,$6F37,$6F38,$6F39,
                               $6F3A,$6F3B,$6F3C,$6F3D,$6F3E,$6F3F,$6F40,$6F41,
                               $6F42,$6F43,$6F44,$6F45,$6F4A,$6F4B,$6F74,$6F78,
                               $6F7B,$6F7E,$6FAD,$6FAE,$7F10,$7F20,$7F21,$7F40,
                               $3F00);
   INEXT='.DAT';
   NOPARIT  = 0;
   PAREVEN  = $18;
   PARODD   = $08;
   BITS8    = $03;
   TDL      = $01;
   LPE      = $02;
   OUT2     = $08;
   COP1     = $21;
   COP2     = $20;
   COM1     = $3F8;
   COM2     = $2F8;
   COM3     = $3E8;
   COM4     = $2E8;
   IRQ3     = $08;
   VECTOR3  = 11;
   IRQ4     = $10;
   VECTOR4  = 12;

VAR
    ATR:array  [1..40] of byte;        { ATR MAXIM 40 BYTES }
    ADN:array  [1..2800] of byte;      { 6F3A ABREV. DIALING NUMBER 100 * $1C }
    CLO:array  [0..4095] of byte;      { USADO POR EMULACION CLONE CARD }
    SMS:array  [1..2640] of byte;      { 6F3C SHORT MESSAGES 15 * $B0 }
    FIL:array  [1..41,1..255] of byte; { MAX 41 FILES OF 255 BYTES }
    MEN:array  [1..41,1..36]  of byte; { FILE MENSAGES }
    ATRLEN   : BYTE;                   { LENGHT FOR ATR  }
    CONVEN   : BOOLEAN;                { ISO CONVENTION, TRUE= NORMAL}
    RES      : BOOLEAN;                { RESET }
    PIN      : WORD;                   { PIN 1 }
    FILENUM  : BYTE;                   { CURRENT FILE NUM  }
    FILENAME : WORD;                   { CURRENT FILE NAME }
    FOUND    : BOOLEAN;                { FOUND SELECTED FILE }
    COUNT    : BYTE;                   { CURRENT FILE BYTE }
    CLA,INS,P1,P2,P3 : BYTE;           { ISO 7816 INSTRUCTIONS  }
    BYTEDLY  : WORD;                   { INTERBYTE DELAY        }
    INP:text;                          { FILE *.DAT }
    T: file of byte ;                  { FOR OPEN FILES AS BIN }
    infile:string[25];                 { NAME OF SIM.DAT FILE}
    line:string[255];                  { INPUT LINE FOR READ SIM.DAT }
    frase:string[25];                  { KEYBOARD BUFFER }
    numline:word;                      { NUM OF LINES    }
    INICIO:WORD;
    LOADERR:boolean;                   { ERROR LOAD SCRIPT FILE }

    RRB,RDM,RCL,RCI,RCM,REL,MSR: word;
    serie,irq,velocidad        : word;
    comnum                     : char;
    dumy                       : byte;
    vector                     : byte;
    lastread,last              : integer;
    Divisor,i,j                : word;
    oldirq                     : pointer;
    BUFSER                     : array [0..2047] of byte;

    salir,ret,abort,error:boolean;
    xpos,ypos:byte;
    key: char;
    screen:array [0..4000] of byte absolute $B800:0000;
    buffer:array [160..4000] of byte;

function hex(b:byte):cad2;
const  digithex: array[0..15] of char ='0123456789ABCDEF';
var BLOW,BHIGH:BYTE;
begin
       BHIGH:=B SHR 4;  BLOW:=B AND $0F;
       hex:=digithex[bhigh]+digithex[blow];
end;

function ihex(b:byte):cad2;
const  digithex: array[0..15] of char ='0123456789ABCDEF';
var BLOW,BHIGH:BYTE;
begin
       BHIGH:=B SHR 4;  BLOW:=B AND $0F;
       ihex:=digithex[blow]+digithex[bhigh];
end;

function hexadr(w:word):cad4;
begin
    hexadr:=hex(trunc(w/256))+hex(w and 255);
end;

procedure clearpan;
var i:integer;
begin
     textbackground(white);
     for i:=80 to 2000 do screen[2*i]:=0;
     gotoxy (1,2);
end;

function mirror (ch:byte):byte;
var k,temp:byte;
begin
      temp:=0;
      ch:=ch xor $ff;
      for k:=0 to 7 do begin
                            temp:=temp shl 1;
                            temp:=temp+((ch shr k) and 1);
                       end;
      mirror:=temp;
end;

procedure entrada(Indicador,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP : Word);
interrupt;
begin
     inline($FB);
     if last >= 1023 then last := 0 else last:=last+1;
     BUFSER[last] := port[RRB];
     port[COP2] := $20;
end;

{$F+}
procedure out;
begin
     Port[RCI]  := 0;
     Port[COP1] := Port[COP1] OR IRQ;
     Port[RCM]  := 0;
     SetIntVec(vector,oldirq);
end;
{$F-}

procedure init;
begin
     irq:=IRQ4;
     vector:=VECTOR4;
     if (serie=com2) or (serie=com4) then
        begin
             irq:=IRQ3;
             vector:=VECTOR3;
        end;
     RRB:= serie;
     RDM:= serie+1;
     RCL:= serie+3;
     RCI:= serie+1;
     RCM:= serie+4;  {modem control register}
     REL:= serie+5;
     MSR:= serie+6;  {modem status register}
     divisor:=115200 div velocidad;
     lastread:= 0;
     last :=0;
     Port[RCI] := 0;
     GetIntVec(vector,oldirq);
     ExitProc := @out;
     SetIntVec(vector,@Entrada);
     Port[RCL]  := Port[RCL] or $80;
     Port[RRB]  := lo(Divisor);
     Port[RDM]  := hi(Divisor);
     if conven then Port[RCL]  := BITS8 OR PAREVEN  { DIRECT CONVENTION }
     else Port[RCL]  := BITS8 OR PARODD;            { INVERS CONVENTION }
     Port[RCM]  := TDL OR LPE OR OUT2;
     Port[COP1] := Port[COP1] AND (NOT IRQ);
     dumy       := Port[RRB];
     dumy       := Port[REL];
     Port[RCI]  := $01;
end;

procedure wait (micros:word); ASSEMBLER;
asm
   mov ah,86h
   mov al,15h
   mov cx,0
   mov dx,micros
   int 15h
end;

function status:boolean;
begin
  if last <> lastread then status:=true
  else status:=false;
end;

function getbyte:byte;
var timeout:longint;
var tmp:byte;
begin
    res:=false;
    repeat tmp:=(port [msr] and $20) until status or keypressed or (tmp=$20);
    if (tmp<>$20) and not keypressed then
          begin
               if lastread >= 1023 then lastread := 0
               else lastread := lastread+1;
               if conven then getbyte:= BUFSER[lastread]
               else getbyte:=mirror (BUFSER[lastread]);
          end
    else  begin
              res:=true;
              getbyte:=0;
          end;
end;

procedure sendbyte(Ch:byte);
begin
     if not conven then ch:=mirror (ch);
     port[RRB]:=ch;
     dumy:=getbyte;
     wait (bytedly);
end;

function sendatr:boolean;
var i:byte;
begin
     i:=1;
     res:=FALSE;
     while not res and (i<=atrlen) and not keypressed do
           begin
                sendbyte (atr[i]);
                write (hex(atr[i]));
                i:=i+1;
           end;
     writeln;
     if not res and not keypressed then sendatr:=TRUE
     else sendatr:=FALSE;
end;

procedure doscroll;
var i:word;
begin
     for i:=160 to 4000-160 do mem[$b800:i]:=mem[$b800:i+160];
     gotoxy (1,24);
end;

procedure screentobuffer;
var i:integer;
begin
     for i:=160 to 4000 do buffer[i]:=mem[$b800:i];
end;

procedure buffertoscreen;
var i:integer;
begin
     for i:=160 to 4000 do mem[$b800:i]:=buffer[i];
end;

PROCEDURE caja( x1, y1, x2, y2 : INTEGER; titulo:STRING;color:byte );
VAR
   Cont : INTEGER;

BEGIN
     textbackground(color);
     textcolor(red);
     FOR Cont:=x1+1 TO x2-1 DO
         BEGIN
              GOTOXY (Cont,y1);WRITE ('');
              GOTOXY (Cont,y2);WRITE ('');
         END;
     Gotoxy(x1, y1); WRITE ('');GOTOXY (x2,y1);WRITE ('');
     Gotoxy(x1, y2); WRITE ('');GOTOXY (x2,y2);WRITE ('');

     FOR Cont := y1+1 TO y2-1 DO
         BEGIN
              Gotoxy( x1, Cont ); WRITE('');
              Gotoxy( x2, Cont ); WRITE('');
         END;
     textcolor (white);
     IF titulo <> '' THEN
        BEGIN
              Gotoxy( x1+1, y1+1 ); WRITE (titulo);
              Gotoxy(x1+1,y1+2);
              for cont:=1 to x2-x1-1 do write ('');
        END;
     textbackground(white);
END;

procedure dec(var outdec:byte;inhex:cad2;var error:boolean);
var nl,nh:byte;
begin
     error:=false;
     nh:=ord(inhex[1]);nl:=ord(inhex[2]);
     if nl>ord('Z') then nl:=nl-32;
     nl:=nl-48;if nl>16 then nl:=nl-7;
     if nh>ord('Z') then nh:=nh-32;
     nh:=nh-48;if nh>16 then nh:=nh-7;
     if (nh>15) or (nl>15) then error:=true;
     outdec:=nh*16+nl;
end;

procedure decadr(var outdec:word;inhex:cad4;var error:boolean);
var nl,nh:cad2;
    l,h:byte;
    error2:boolean;
begin
     nh:=inhex[1]+inhex[2];dec(h,nh,error);
     nl:=inhex[3]+inhex[4];dec(l,nl,error2);
     outdec:=h*256+l;
     error:=error or error2;
end;

procedure lee(n:byte);   { lee un string de n chars y devuelve string frase}
var  i,a:byte;
     cad: string;
     error:integer;
begin     i:=1;
          cad[i]:=readkey;
          while ((i<n) and (cad[i]<>#13)) do
                begin
                     if (cad[i]<>#13) and (cad[i]<>#8) and (cad[i]<>#0) then write (cad[i]);
                     if (cad[i]=#8) and (i=1) then i:=0;
                     if (cad[i]=#8) and (i>1) then
                         begin
                              i:=i-2;
                              write(#8,#32,#8);
                         end;
                     if (cad[i]<>#0) then i:=i+1;
                     cad[i]:=readkey;
                end;
          if cad[i]<>#13 then write(cad[i]);
          if cad[i]=#13 then i:=i-1;
          cad[0]:=chr(i);
          frase:=cad;
          for i:=1 to ord(frase[0]) do if (frase[i]>='a') and (frase[i]<='z') then frase[i]:=chr(ord(frase[i])-32);
end;

procedure quitacar;
begin
     line:=Copy (line,2,ord(line[0])-1);
end;

procedure quitaespacios;
begin
     while (line[1]=' ') and (ord(line[0])>0) do quitacar;
end;

procedure request(texto:string;timdel:boolean);
begin
      screentobuffer;
      caja (24,5,48,9,'  ASIM EMULATOR V2.9   ',black);
      gotoxy (25,8);
      textcolor (blue);
      write('                       ');
      gotoxy (26,8);
      write(texto);
      gotoxy (80,1);
      if timdel then key:=readkey
      else delay (250);
      buffertoscreen;
end;

procedure exit;
begin
     salir:=true;
end;

procedure dosshell;
begin
     textcolor (white);
     textbackground(black);
     clrscr;
     writeln ('TYPE EXIT TO RETURN TO ASIM ');
     exec(getenv('Comspec'),'');
     textcolor (white);
     textbackground(7);
     clrscr;
end;

procedure findfile;
var tmp:cad4;
begin
     i:=0;
     found:=FALSE;
     COUNT:=0;      { current byte of selected file }
     quitacar;
     quitaespacios;
     tmp:=copy(line,1,4);
     decadr(filename,tmp,error);
     line:=copy(line,5,ord(line[0])-4);
     quitaespacios;
     if not error then while ((i<41) and (not found)) do
        begin
             i:=i+1;
             if (nam[i]=filename) then found:=TRUE;
        end;
     if found then filenum:=i
     else begin
               writeln (' FILE NOT FOUND IN LINE ',numline);
               LOADERR:=TRUE;
          end;
end;

procedure storebyte(mem:boolean);
var tmp:cad2;
begin
    while ((ord(line[0])>1) and not error and (line[1]<>';')) do
          begin
               tmp:=copy(line,1,2);
               dec(dumy,tmp,error);
               COUNT:=COUNT+1;
               if mem then men[filenum,COUNT]:=dumy
               else fil[filenum,COUNT]:=dumy;
               quitacar;
               quitacar;
               quitaespacios;
               if ((line[1]=#$0a) or (line[1]=#$0d)) then line[0]:=#0;
          end;
    if error then
       begin
             LOADERR:=TRUE;
             writeln;
             writeln ('  Error in line: ',numline);
       end;
end;

procedure storeatr;
var tmp:cad2;
begin
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     COUNT:=0;
     tmp:=copy(line,1,2);
     dec(dumy,tmp,error);
     quitacar;
     quitacar;
     quitaespacios;
     if (error or (dumy>32)) then
        begin
             writeln('Error in ATR LENGHT');
             LOADERR:=TRUE;
        end
     else begin
               atrlen:=dumy;
               conven:=TRUE;  { assumes direct convention }
               while ((ord(line[0])>1) and not error and (line[1]<>';')) do
                     begin
                          tmp:=copy(line,1,2);
                          dec(dumy,tmp,error);
                          count:=count+1;
                          atr[count]:=dumy;
                          quitacar;
                          quitacar;
                          quitaespacios;
                          if ((line[1]=#$0a) or (line[1]=#$0d)) then line[0]:=#0;
                     end;
               if error then
                  begin
                       LOADERR:=TRUE;
                       writeln;
                       writeln ('  Error in ATR FILE');
                  end
               else if (atr[1]=$3F) then conven:=FALSE;
           end;
end;

procedure storecom;
begin
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     comnum:=line[1];
     case comnum of
                       '1': serie:=COM1;
                       '2': serie:=COM2;
                       '3': serie:=COM3;
                       '4': serie:=COM4;
                        else writeln;
                             writeln (' ERROR SERIAL PORT NOT VALID ');
                             LOADERR:=TRUE;
                        end;
end;

procedure storebaud;
var tmp:word;
begin
     quitacar;
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     line:=copy (line,1,pos(' ',line)-1);
     val (line,tmp,i);
     if ((i<>0) or (tmp=0)) then
        begin
             writeln;
             writeln (' ERROR BAUD RATE NOT VALID ');
             LOADERR:=TRUE;
        end
     else velocidad:=tmp;
end;

procedure storepin;
var tmp:word;
begin
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     line:=copy (line,1,pos(' ',line)-1);
     val (line,tmp,i);
     if ((i<>0) or (tmp=0)) then
        begin
             writeln;
             writeln (' ERROR PIN NOT VALID ');
             LOADERR:=TRUE;
        end
     else pin:=tmp;
end;

procedure storedly;
var tmp:word;
begin
     quitacar;
     quitacar;
     quitacar;
     quitacar;
     quitaespacios;
     line:=copy (line,1,pos(' ',line)-1);
     val (line,tmp,i);
     if ((i<>0) or (tmp=0)) then
        begin
             writeln;
             writeln (' ERROR INTER BYTE DELAY NOT VALID ');
             LOADERR:=TRUE;
        end
     else bytedly:=tmp;
end;

procedure dump (adr:word);
var
    k,n:byte;
begin
     textbackground(7);
     write(hexadr(adr),'       ');
     for k:=0 to 15 do write(hex(CLO[adr+k]),' ');
     write(' ');
     for k:=0 to 15 do
         begin
              n:=CLO[adr+k];
              if n<31 then n:=128+n;
              write(chr(n));
         end;
     if wherey<25 then writeln;
end;

procedure pagedown;
var i:word;
begin
     gotoxy(1,2);
     inicio:=inicio+16*24;
     if inicio>3712 then inicio:=3712;
     for i:=0 to 23 do dump(inicio+i*16);
     screen[2*(ypos*80+xpos)-1]:=71;
end;

procedure pageup;
var i:word;
begin
     gotoxy(1,2);
     if inicio<16*24 then inicio:=16*24;
     inicio:=inicio-16*24;
     for i:=0 to 23 do dump(inicio+i*16);
     screen[2*(ypos*80+xpos)-1]:=71;
end;

procedure scrollup;
var i:word;
begin
     i:=2000;
     while i>80 do
           begin
                screen[2*i]:=screen[2*i-160];
                i:=i-1;
           end;
     inicio:=inicio-16;
     gotoxy (1,2);
     dump (inicio);
     screen[2*(ypos*80+xpos)-1]:=71;
end;

procedure scrolldown;
var i:word;
begin
     for i:=80 to 2000 do screen[2*i]:=screen[2*i+160];
     inicio:=inicio+16;
     gotoxy(1,25);
     dump (inicio+23*16);
     screen[2*(ypos*80+xpos)-1]:=71;
end;

procedure seeframe;
begin
     inicio:=0;
     gotoxy (1,2);
     xpos:=1;
     ypos:=1;
     for i:=0 to 23 do dump ((inicio+i*16));
     key:=#0;
     screen[2*(ypos*80+xpos)-1]:=71;
     while key<>#27 do
           begin
                key:=readkey;
                if key=#0 then key:=readkey;
                if key=#80 then
                   begin
                        if ypos<24 then
                           begin
                                screen[2*(ypos*80+xpos)-1]:=127;
                                ypos:=ypos+1;
                                screen[2*(ypos*80+xpos)-1]:=71;
                           end
                        else if inicio <($1000-24*16) then scrolldown;
                   end;
                if key=#72 then
                   begin
                        if ypos>1 then
                           begin
                                screen[2*(ypos*80+xpos)-1]:=127;
                                ypos:=ypos-1;
                                screen[2*(ypos*80+xpos)-1]:=71;
                           end
                        else if inicio >0 then scrollup;
                   end;
                if key=#77 then
                   begin
                        if xpos<80 then
                           begin
                                screen[(ypos*80+xpos)*2-1]:=127;
                                xpos:=xpos+1;
                                screen[2*(ypos*80+xpos)-1]:=71;
                           end
                   end;
                if key=#75 then
                   begin
                        if xpos>1 then
                           begin
                                screen[(ypos*80+xpos)*2-1]:=127;
                                xpos:=xpos-1;
                                screen[2*(ypos*80+xpos)-1]:=71;
                           end
                   end;
                if key=#81 then pagedown;
                if key=#73 then pageup;

           end;
     screen[2*(ypos*80+xpos)-1]:=127;
end;


procedure edithex;
VAR especial:boolean;
    nh,nl,old:byte;

function valid:boolean;
begin
     valid:=true;
     if ((xpos-14) mod 3)=0 then valid:=false;
end;

begin
     gotoxy (50,1);
     write ('        HEX EDIT           ');
     textbackground (white);
     gotoxy (1,2);
     xpos:=1;
     ypos:=1;
     for i:=0 to 23 do dump ((inicio+i*16));
     xpos:=12; {primer caracter hex}
     key:=#0;
     while key <>#27 do
           begin
                screen[2*(ypos*80+xpos)-1]:=71;
                especial:=false;
                key:=readkey;
                if key=#0 then
                   begin
                        key:=readkey;
                        especial:=true;
                   end;
                if especial then
                   begin
                        if  key=#77  then
                            begin
                                  screen[(ypos*80+xpos)*2-1]:=127;
                                  xpos:=xpos+1;
                                  if xpos >58 then
                                     begin
                                          xpos:=12;
                                          ypos:=ypos+1;
                                     end;
                                  if ypos>24 then ypos:=24;
                                  screen[2*(ypos*80+xpos)-1]:=71;
                            end;
                        if  key=#75  then
                            begin
                                  screen[(ypos*80+xpos)*2-1]:=127;
                                  xpos:=xpos-1;
                                  if xpos<12 then
                                     begin
                                          xpos:=58;
                                          ypos:=ypos-1;
                                     end;
                                  if ypos<1 then ypos:=1;
                                  screen[2*(ypos*80+xpos)-1]:=71;
                            end;
                        if ((key=#80) and (ypos<24)) then
                            begin
                                  screen[(ypos*80+xpos)*2-1]:=127;
                                  ypos:=ypos+1;
                                  screen[2*(ypos*80+xpos)-1]:=71;
                            end;
                        if ((key=#72) and (ypos>1)) then
                            begin
                                  screen[(ypos*80+xpos)*2-1]:=127;
                                  ypos:=ypos-1;
                                  screen[2*(ypos*80+xpos)-1]:=71;
                            end;
                   end
                else if (key >#31) and (valid) then
                     begin
                           if (xpos mod 3)=0 then
                              begin
                                   old:=clo[inicio+(xpos-12) div 3+16*(ypos-1)];
                                   old:=(old and $0f);
                                   nh:=ord(key);
                                   if nh>ord('Z') then nh:=nh-32;
                                   nh:=nh-48;if nh>16 then nh:=nh-7;
                                   if nh<16 then
                                      begin
                                           gotoxy (xpos,ypos+1);
                                           write (key);
                                           old:=nh*16+old;
                                           clo[inicio+(xpos-12) div 3+16*(ypos-1)]:=old;
                                           gotoxy ((xpos-12) div 3+61,ypos+1);
                                           write (chr(old));
                                           xpos:=xpos+1;
                                           gotoxy (xpos,ypos+1);
                                      end;
                              end
                           else begin
                                     old:=clo[inicio+(xpos-12) div 3+16*(ypos-1)];
                                     old:=(old and $f0);
                                     nl:=ord(key);
                                     if nl>ord('Z') then nl:=nl-32;
                                     nl:=nl-48;if nl>16 then nl:=nl-7;
                                     if nl<16 then
                                        begin
                                             gotoxy(xpos,ypos+1);
                                             write (key);
                                             old:=old+nl;
                                             clo[inicio+(xpos-12) div 3+16*(ypos-1)]:=old;
                                             gotoxy ((xpos-13) div 3+61,ypos+1);
                                             write (chr(old));
                                             xpos:=xpos+2;
                                             gotoxy (xpos,ypos+1);
                                        end;
                                end;
                           if xpos >58 then
                              begin
                                   xpos:=12;
                                   ypos:=ypos+1;
                              end;
                           if ypos>24 then ypos:=24;
                     end;
           end;
    screen[2*(ypos*80+xpos)-1]:=127;
end;

procedure clearbuf;
begin
     for i:=0 to 4095 do clo[i]:=0;
end;


procedure analice;
begin
     for i:=1 to ord(line[0]) do if (line[i]>='a') and (line[i]<='z') then line[i]:=chr(ord(line[i])-32);
     if (line[1]='*') then
        begin
             if line[2]='*' then
                begin
                     quitacar;
                     quitacar;
                     quitaespacios;
                end
             else findfile;
             storebyte(TRUE);
        end
     else if (line[1]='#') then
          begin
               if line[2]='#' then
                  begin
                       quitacar;
                       quitacar;
                       quitaespacios;
                  end
               else findfile;
               storebyte(FALSE);
          end
    else if (line[1]='!') then
         begin
              quitacar;
              quitaespacios;
              if copy(line,1,3)='ATR' then storeatr
              else if copy(line,1,3)='COM' then storecom
                   else if copy(line,1,4)='BAUD' then storebaud
                        else if copy(line,1,3)='PIN' then storepin
                             else if copy(line,1,4)='BDLY' then storedly;
         end
    else begin
              writeln ('  Error at line: ',numline);
              LOADERR:=TRUE;
         end;
end;

procedure loads19;
var k:byte;
    a:char;
    p,n:cad2;
    adr:cad4;
    cont,suma:byte;
    error,chk:boolean;
begin
     assign (inp,infile);
     reset (inp);
     error:=false;
     read(inp,p);while (p<>'S1') and (p<>'S9') do read(inp,p);
     while not eof(inp) and (p<>'S9') and (not error) and not keypressed do
           begin
                read(inp,n);
                dec(cont,n,error);
                suma:=cont;
                cont:=cont-3;
                read(inp,adr);
                decadr(inicio,adr,error);
                suma:=suma+lo(inicio)+hi(inicio);
                for k:=0 to cont-1 do
                    begin
                         read(inp,n);
                         dec(dumy,n,error);
                         suma:=suma+dumy;
                         clo[inicio+k]:=dumy;
                    end;
                suma:= not suma;
                read(inp,p);  {checksum}
                dec(dumy,p,error);
                if (dumy<>suma) and chk then loaderr:=true;
                read(inp,a);
                read(inp,a);
                while (p<>'S1') and (p<>'S9') and not eof(inp) and not keypressed do read(inp,p);
           end;
     close (inp);
     clearpan;
     gotoxy (2,3);
     textcolor (red);
     if LOADERR then write (' CHECKSUM ERROR LOADING FRAME FILE ')
     else if keypressed then write (' LOAD FRAME ABORTED BY USER ')
          else begin
                    inicio:=0;
                    gotoxy (1,2);
                    textcolor (white);
                    for i:=0 to 23 do dump ((inicio+i*16));
               end;
end;

procedure SAVES19;
var cont,k:word;
    suma:byte;
    Nbytes,j:byte;

begin
     inicio:=0;
     Nbytes:=16+3;
     cont:=($1000-inicio) div (Nbytes-3);
     for k:=1 to cont do
         begin
              write(inp,'S1',hex(Nbytes),hex(hi(inicio)),hex(lo(inicio)));
              suma:=Nbytes+lo(inicio)+hi(inicio);
              for j:=0 to Nbytes-4 do
                  begin
                       suma:=suma+clo[inicio+j];
                       write(inp,hex(clo[inicio+j]));
                  end;
              writeln (inp,hex(not suma));
              inicio:=inicio+16;
         end;
     writeln(inp,'S9',hex(3),hex(0),hex(0),hex($FC));
     {$i+} close(inp);
     inicio:=0;
end;

procedure carga;
begin
      LOADERR:=FALSE;
      assign(t,infile);
      {$I-} reset(t); {$I+}
      if ioresult<>0 then request('ERROR FILE NOT FOUND.',TRUE)
      else begin
             numline:=0;
             assign (inp,infile);
             reset (inp);
             request(' Loading SIM  File. ',FALSE);
             clearpan;
             gotoxy (2,2);
             while not eof(inp) do
                   begin
                        readln(inp,line);
                        line:=line+'   ';
                        quitaespacios;
                        if ((ord(line[0])>0) and (line[1]<>';')) then analice;
                        numline:=numline+1;
                   end;
             close(inp);
             writeln;
             textcolor (red);
             if LOADERR then write ('  SOME ERRORS FOUND LOADING SIM FILE')
             else begin
                       clearpan;
                       gotoxy (2,3);
                       textcolor (red);
                       write ('SIM FILE LOADED SUCCESFULLY');
                       out;
                       init; { RE INITS UART }
                  end;
      end;
end;

procedure loadfras19;
begin
      screentobuffer;
      caja (25,5,58,9,'   LOAD  *.S19   FRAME FILE     ',black);
      gotoxy (26,8);
      write('                                ');
      gotoxy (26,8);
      textcolor (blue);
      write('NAME: ');
      lee (25);
      if pos('.',frase)<>0 then frase:=copy(frase,1,pos('.',frase)-1);
      infile:=frase+'.S19';
      buffertoscreen;
      LOADERR:=FALSE;
      assign(t,infile);
      {$I-} reset(t); {$I+}
      if ioresult<>0 then request('ERROR FILE NOT FOUND.',TRUE)
      else loads19;
end;

procedure savefras19;
begin
      screentobuffer;
      caja (25,5,58,9,'   SAVE  *.S19   FRAME FILE     ',black);
      gotoxy (26,8);
      write('                                ');
      gotoxy (26,8);
      textcolor (blue);
      write('NAME: ');
      lee (25);
      if pos('.',frase)<>0 then frase:=copy(frase,1,pos('.',frase)-1);
      infile:=frase+'.S19';
      buffertoscreen;
      LOADERR:=FALSE;
      assign(inp,infile);
      {$i-} rewrite(inp);
      if ioresult=0 then SAVES19
      else request('ERROR WRITING FILE.',TRUE)
end;

procedure loadfrabin;
begin
      screentobuffer;
      caja (25,5,58,9,'   LOAD  *.BIN   FRAME FILE     ',black);
      gotoxy (26,8);
      write('                                ');
      gotoxy (26,8);
      textcolor (blue);
      write('NAME: ');
      lee (25);
      if pos('.',frase)<>0 then frase:=copy(frase,1,pos('.',frase)-1);
      infile:=frase+'.BIN';
      buffertoscreen;
      LOADERR:=FALSE;
      assign(t,infile);
      {$I-} reset(t); {$I+}
      if ioresult=0 then
         begin
              i:=0;
              while not eof(t) and (i<4096) do
                    begin
                          read(t,dumy);
                          clo[i]:=dumy;
                          i:=i+1;
                    end;
              close(t);
              clearpan;
              gotoxy (2,3);
              textcolor (red);
              inicio:=0;
              gotoxy (1,2);
              textcolor (white);
              for i:=0 to 23 do dump ((inicio+i*16));
         end
      else request('ERROR FILE NOT FOUND.',TRUE);
end;

procedure comparebin;
var verify:boolean;
begin
      verify:=TRUE;
      screentobuffer;
      caja (25,5,58,9,'  COMPARE  *.BIN   FRAME FILE   ',black);
      gotoxy (26,8);
      write('                                ');
      gotoxy (26,8);
      textcolor (blue);
      write('NAME: ');
      lee (25);
      if pos('.',frase)<>0 then frase:=copy(frase,1,pos('.',frase)-1);
      infile:=frase+'.BIN';
      buffertoscreen;
      LOADERR:=FALSE;
      assign(t,infile);
      {$I-} reset(t); {$I+}
      if ioresult=0 then
         begin
              clearpan;
              gotoxy (1,3);
              textcolor (red);
              i:=0;
              while not eof(t) and (i<4096) do
                    begin
                         read(t,dumy);
                         if clo[i]<>dumy then
                            begin
                                 verify:=FALSE;
                                 writeln ('Adress $',hexadr(i),' buffer=$',hex(clo[i]),' file=$',hex(dumy));
                                 if (wherey>=25) then doscroll;
                            end;
                         i:=i+1;
                    end;
                    close(t);
                    if verify then writeln ('BUFFER AND FILE CONTENTS ARE EQUAL');
         end
      else request('ERROR FILE NOT FOUND.',TRUE);
end;

procedure savefrabin;
begin
      screentobuffer;
      caja (25,5,58,9,'   SAVE  *.BIN   FRAME FILE     ',black);
      gotoxy (26,8);
      write('                                ');
      gotoxy (26,8);
      textcolor (blue);
      write('NAME: ');
      lee (25);
      if pos('.',frase)<>0 then frase:=copy(frase,1,pos('.',frase)-1);
      infile:=frase+'.BIN';
      buffertoscreen;
      LOADERR:=FALSE;
      assign(t,infile);
      {$i-} rewrite(t);
      if ioresult=0 then
         begin
              i:=0;
              while (i<4096) do
                    begin
                         dumy:=clo[i];
                         write(t,dumy);
                         i:=i+1;
                     end;
              {$i+} close(t);
              inicio:=0;
         end
      else request('ERROR WRITING FILE.',TRUE)
end;

procedure loadsim;
begin
      screentobuffer;
      caja (25,5,58,9,'   LOAD  *.DAT   GSM SIM FILE   ',black);
      gotoxy (26,8);
      write('                                ');
      gotoxy (26,8);
      textcolor (blue);
      write('NAME: ');
      lee (25);
      if pos('.',frase)<>0 then frase:=copy(frase,1,pos('.',frase)-1);
      infile:=frase+inext;
      buffertoscreen;
      carga;
end;

procedure notload;
begin
     clearpan;
     textcolor (red);
     gotoxy (3,3);
     write (' No SIM file Loaded.  ');
end;

procedure dispfile;
var tmp:byte;
begin
     i:=0;
     found:=false;
     gotoxy (1,3);
     if not error then while ((i<41) and (not found)) do
        begin
             i:=i+1;
             if (nam[i]=filename) then found:=TRUE;
        end;
     if not found then writeln (' ERROR BAD FILE ')
     else begin
               filenum:=i;
               i:=1;
               write ('    ',hexadr(filename),'  ');
               while (i<men[filenum,4]) do
                     begin
                          if ((men[filenum,4]-i)<15) then tmp:=men[filenum,4]-i+1
                          else tmp:=16;
                          for dumy:=1 to tmp do write (hex(fil[filenum,i+dumy-1]),' ');
                          writeln;
                          write ('          ');
                          i:=i+dumy;
                     end;
          end;
end;

procedure seead;
begin
     clearpan;
     gotoxy (2,3);
     filename:=$6fad;
     error:=false;
     dispfile;
     gotoxy (40,3);
     textcolor (red);
     if (fil[filenum,1]and$80)=$80 then write ('VALID MOTOROLA TEST CARD')
     else write ('NOT VALID MOTOROLA TEST CARD');
end;

procedure seeimsi;
begin
     clearpan;
     gotoxy (2,3);
     filename:=$6F07;
     error:=false;
     dispfile;
     gotoxy (50,3);
     textcolor (red);
     for i:=2 to fil[filenum,1]+1 do write (ihex(fil[filenum,i]));
end;

procedure seeiccard;
begin
     clearpan;
     gotoxy (2,3);
     filename:=$2FE2;
     error:=false;
     dispfile;
     gotoxy (50,3);
     textcolor (red);
     for i:=2 to (fil[filenum,1] shr 4)+1 do write (ihex(fil[filenum,i]));
end;

procedure seefile;
begin
     clearpan;
     textcolor (blue);
     gotoxy (2,3);
     clearpan;
     screentobuffer;
     gotoxy (2,3);
     caja (25,5,42,9,' See 6FXX FILE. ',black);
     textcolor (blue);
     gotoxy (26,8);
     write('                ');
     gotoxy (26,8);
     write('FILE ? : ');
     lee (5);
     buffertoscreen;
     textcolor (white);
     decadr(filename,frase,error);
     dispfile;
end;

procedure seeatr;
begin
     clearpan;
     textcolor (red);
     gotoxy (3,3);
     write ('ATR: ');
     textcolor (black);
     for i:=1 to atrlen do write (hex(atr[i]),' ');
end;

procedure seepin;
begin
     clearpan;
     textcolor (red);
     gotoxy (3,3);
     write ('PIN: ');
     textcolor (black);
     write (pin);
end;

 { ---------------------- SIM EMULATION ROUTINES -------------------- }

procedure getiso;
begin
     cla:=0;
     ins:=0;
     CLA:=getbyte;
     if not res then INS:=getbyte;
     if not res then P1:=getbyte;
     if not res then P2:=getbyte;
     if not res then P3:=getbyte;
end;

procedure checkreset;
var atrok:boolean;
begin
     atrok:=false;
     while not atrok and not abort do
           begin
                while (((port[MSR] and $20)=$20) and not keypressed) do;
                clearpan;
                lastread:= 0;
                last :=0;
                if keypressed then abort:=true
                else begin
                           gotoxy(1,3);
                           textcolor(red);
                           write ('RESET FROM PHONE ... SENDING ATR.   ');
                           textcolor(blue);
                           if sendatr then atrok:=true;
                      end;
           end;
end;

procedure verify_pin;
var tmp:word;
begin
     wait(2000);
     sendbyte (ins);
     write ('PIN VERIFY: ');
     for i:=1 to P3 do frase[i]:=(chr(getbyte));
     frase[0]:=#4;
     val (frase,tmp,i);
     wait(2000);
     if (tmp=pin) then begin
                            write (tmp,' OK');
                            sendbyte ($90);
                            sendbyte ($00);
                        end
     else begin
                write (tmp, ' ERROR');
                sendbyte ($98);
                sendbyte ($04);
          end;
     writeln;
end;

procedure change_pin;
begin
     wait(2000);
     sendbyte (ins);
     write ('CHANGE PIN: ');
     for i:=1 to P3 do write (chr(getbyte));
     writeln;
     wait(2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure pinoff;
begin
     wait(2000);
     sendbyte (ins);
     write ('PIN OFF: ');
     for i:=1 to P3 do write (chr(getbyte));
     writeln;
     wait(2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure pinon;
begin
     wait(2000);
     sendbyte (ins);
     write ('PIN ON: ');
     for i:=1 to P3 do write (chr(getbyte));
     writeln;
     wait(2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure algorithm;
begin
     wait(2000);
     sendbyte (ins);
     write ('AUTHENTICATION REQUEST: ');
     for i:=1 to P3 do write (HEX(getbyte),' ');
     writeln;
     wait(2000);
     sendbyte ($9F);
     sendbyte ($0C);
end;

procedure select;
begin
      i:=0;
      wait (2000);
      found:=false;
      sendbyte (ins); {manda procedure byte}
      filename:=getbyte*256;
      filename:=filename+getbyte;
      write ('SELECT FILE: $',hexadr(filename));
      while ((i<41) and (not found)) do
              begin
                   i:=i+1;
                   if (nam[i]=filename) then found:=TRUE;
              end;
      if found then
              begin
                    filenum:=i;
                    wait (2000);
                    sendbyte ($9F);
                    if ((filename=$7f20) OR (filename=$7f10) OR (filename=$7f21)) then sendbyte ($16)
                    else sendbyte ($0F);
              end
       else   begin
                    wait (2000);
                    write (' NOT FOUND');
                    sendbyte ($94);
                    sendbyte ($04);
              end;
       writeln;
end;

procedure readbin;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('READFILE:    $',hexadr(nam[filenum]));
     for i:=1 to P3 do sendbyte (fil[filenum,i]);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure cloneread;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('SENDING FRAME AT ADRESS  $',hexadr(p1*256+p2));
     for i:=1 to P3 do sendbyte(clo[p1*256+p2+i-1]);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure clonestore;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('GETING FRAME FROM ADRESS $',hexadr(p1*256+p2));
     for i:=1 to P3 do clo[p1*256+p2+i-1]:=getbyte;
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure clonepin;
var tmp:word;
begin
     wait(2000);
     sendbyte (ins);
     write ('CLONE PIN: ');
     for i:=1 to P3 do write (chr(getbyte));
     wait(2000);
     sendbyte ($90);
     sendbyte ($00);
     writeln;
end;

procedure readrec;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('READREC:     $',hexadr(nam[filenum]),' ',P1);
     for i:=1 to P3 do sendbyte (fil[filenum,(P1-1)*P3+I]);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure message;
begin
     wait (2000);
     sendbyte (ins);
     for i:=1 to P3 do sendbyte (men[filenum,i]);
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure writebin;
begin
     wait (2000);
     sendbyte (ins);
     for i:=1 to P3 do fil[filenum,i]:=getbyte;
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure reinit;
begin
     wait (2000);
     sendbyte (ins);
     write ('RESET CHARGE COUNTER: ');
     for i:=1 to P3 do write (HEX(getbyte),' ');
     writeln;
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure sleep;
begin
     wait (2000);
     sendbyte (ins);
     writeln ('SLEEP SIM');
     wait (2000);
     sendbyte ($90);
     sendbyte ($00);
end;

procedure emulate;
begin
     abort:=false;
     clearpan;
     gotoxy (5,3);
     textcolor (red);
     write(' Port= COM',comnum);
     write('   Baud= ',velocidad);
     write('   Delay= ',bytedly);
     write('   ISO Convention ');
     if conven then write ('Direct')
     else write ('Invers');
     textcolor (yellow);
     gotoxy (8,5);
     write('### WAITING RESET ###');
     textcolor (blue);
     gotoxy (79,1);
     lastread:= 0;
     last :=0;
     while not abort do
           begin
                if (((port[MSR] and $20)=$20)) then checkreset;
                getiso;
                case INS of
                            $20: verify_pin;
                            $24: change_pin;
                            $26: pinoff;
                            $28: pinon;
                            $88: algorithm;
                            $a4: select;
                            $b0: readbin;
                            $b2: readrec;
                            $c0: message;
                            $d6: writebin;
                            $dc: reinit;
                            $fa: sleep;
                 end;
                 if keypressed then abort:=true
                 else if (wherey>=25) then doscroll;
           end;
end;

procedure clonemul;
begin
     abort:=false;
     clearpan;
     gotoxy (5,3);
     textcolor (red);
     write(' Port= COM',comnum);
     write('   Baud= ',velocidad);
     write('   Delay= ',bytedly);
     write('   ISO Convention ');
     if conven then write ('Direct')
     else write ('Invers');
     textcolor (yellow);
     gotoxy (8,5);
     write('### CLONE CARD EMULATING ... WAITING RESET ###');
     textcolor (blue);
     gotoxy (79,1);
     lastread:= 0;
     last :=0;
     while not abort do
           begin
                if (((port[MSR] and $20)=$20)) then checkreset;
                getiso;
                case INS of
                           $20: clonepin;
                           $b0: cloneread;
                           $d0: clonestore;
                end;
                if keypressed then abort:=true
                else if (wherey>=25) then doscroll;
           end;
end;

{ --------------------------- START of MENU -------------------------}

procedure menu;
const n=4; {max 6 items for menu}
      k=6;
      field:  array[0..k,1..n] of string[20]=
      (('File','View File','Emulator','Clone'),
       ('Load SIM','RESET ATR','RUN AUTO','RUN CLONE'),
       ('Load FRAME S19','PIN','Send ATR','VIEW FRAME '),
       ('Save FRAME S19','FILE  6Fxx','Get Iso','EDIT FRAME'),
       ('CLEAR FRAME','ICCARD','Send Proc. Byte','LOAD FRAME BIN'),
       ('DOS  SHELL','IMSI','Send SW1 SW2','SAVE FRAME BIN'),
       ('Exit','ADMI. DATA','Send Data ','COMPARE FRAME BIN'));

     actfield:array[1..n] of boolean=(false,false,false,false);
var  x,y,oldx,oldy,i,max:byte;
     opc,oldfield:byte;
     tecla:byte;
     ok,ok2:boolean;

function tvalida:boolean;
begin
     tvalida:=false;
     if ((tecla=75) or (tecla=77) or (tecla=27) or (tecla=80) or (tecla=72) or (tecla=13)) then tvalida:=true;
end;

procedure writeItem(num:byte);
var i,j:byte;
begin
     textbackground(black);
     max:=length(field[1,num]);
     for i:=2 to k do if length(field[i,num])>max then max:=length(field[i,num]);
     max:=max+6;
     gotoxy (4+12*(num-1),2);
     write('');for i:=1 to max-1 do write('');write('');
     for i:=3 to k+3 do begin
                              gotoxy(4+12*(num-1),i);
                              write('');
                              textbackground(blue);
                              for j:=1 to max-1 do write(' ');
                              textbackground(black);
                              gotoxy(4+12*(num-1)+max,i);
                              write('');
                         end;
     gotoxy (4+12*(num-1),3+k);
     write('');for i:=1 to max-1 do write('');write('');
     textbackground(blue);
     for i:=1 to k do begin
                            gotoxy(6+12*(num-1),2+i);
                            write(field[i,num]);
                      end;
end;

procedure fila(columna:byte);
var i:byte;
begin
     gotoxy(5+12*(x-1),oldy+1);
     textbackground(blue);write(' '+field[oldy-1,x]);
     for i:=3 to max-length(field[oldy-1,x]) do write(' ');
     gotoxy(5+12*(x-1),columna+1);
     textbackground(magenta);write(' '+field[columna-1,x]);
     for i:=3 to max-length(field[columna-1,x]) do write(' ');
     gotoxy(70,24);
end;

procedure barra(campo:byte);
var i:byte;
begin
     if oldfield<>campo then
         begin
              actfield[oldfield]:=false;
              oldfield:=campo;
              actfield[campo]:=true;
         end;
     textbackground(blue);
     textcolor(white);
     gotoxy(1,1);clreol;
     gotoxy(1,1);for i:=1 to n do
        begin
             if actfield[i] then textbackground(magenta);
             gotoxy(4+12*(i-1),1);write(field[0,i]);
             textbackground(blue);
        end;
    TEXTCOLOR (GREEN);
    gotoxy(52,1); write ('ASIM EMULATOR V2.9 ');
    textcolor(white);gotoxy(10,10);
end;

begin
     ok:=false;
     ok2:=false;
     oldy:=2;
     x:=1;
     y:=1;
     oldfield:=2;
     barra (x);
     screentobuffer;
     while not ok do
           begin
                gotoxy (80,1);
                tecla:=0;
                while not tvalida do
                      begin
                           tecla:=ord(readkey);
                           if tecla=0 then tecla:=ord(readkey);
                      end;
                if tecla=27 then
                      begin
                            ok:=true;
                            y:=99;
                      end;
                if tecla=77 then
                      begin
                            x:=x+1;
                            if x>4 then x:=1;
                            barra (x);
                            if y>1 then
                               begin
                                    buffertoscreen;
                                    writeitem(x);
                                    fila(y);
                               end;
                      end;
                 if tecla=75 then
                      begin
                            x:=x-1;
                            if x<1 then x:=4;
                            barra (x);
                            if y>1 then
                               begin
                                    buffertoscreen;
                                    writeitem(x);
                                    fila(y);
                               end;
                      end;
                 if tecla=13 then
                      begin
                            if y>1 then ok:=true
                            else begin
                                       Y:=Y+1;
                                       writeitem (x);
                                       fila (y);
                                       oldy:=y+1;
                                       ok2:=true;
                                   end;
                      end;
                 if ((tecla=80) and (ok2)) then
                      begin
                            if y=1 then y:=2;
                            oldy:=y;
                            y:=y+1;
                            if y>7 then y:=2;
                            fila (y);
                      end;
                 if ((tecla=72) and (ok2)) then
                      begin
                            if y=1 then y:=2;
                            oldy:=y;
                            y:=y-1;
                            if y<2 then y:=7;
                            fila (y);
                      end;
           end;
     barra(5);
     buffertoscreen;
     if y<>99 then begin
                        y:=y-1;
                        opc:=x*10+y;
                        case opc of
                                     11: loadsim;
                                     12: loadfras19;
                                     13: savefras19;
                                     14: begin
                                              clearbuf;
                                              inicio:=0;
                                              gotoxy (1,2);
                                              for i:=0 to 23 do dump ((inicio+i*16));
                                         end;
                                     15: dosshell;
                                     16: exit;

                                     21: if atrlen=0 then notload
                                         else seeatr;
                                     22: if atrlen=0 then notload
                                         else seepin;
                                     23: if atrlen=0 then notload
                                         else seefile;
                                     24: if atrlen=0 then notload
                                         else seeiccard;
                                     25: if atrlen=0 then notload
                                         else seeimsi;
                                     26: if atrlen=0 then notload
                                         else seead;

                                     31: if atrlen=0 then notload
                                         else emulate;
                                     32: ;
                                     33: ;
                                     34: ;
                                     35: ;
                                     36: ;

                                     41: if atrlen=0 then notload
                                         else clonemul;
                                     42: seeframe;
                                     43: edithex;
                                     44: loadfrabin;
                                     45: savefrabin;
                                     46: comparebin;
                        end;
                   end;
end;

begin
     {$M 16384,0,0}
     checkbreak:=false;
     serie:=COM2;
     velocidad:=8736;
     bytedly:=4000;
     conven:=TRUE;
     pin:=3333;
     init;
     textcolor(white);
     textbackground(7);
     clrscr;
     salir:=false;
     filenum:=21;
     atrlen:=0;
     count:=0;
     for i:=1 to 41 do for j:=1 to 255 do fil[i,j]:=$00;
     for i:=1 to 41 do for j:=1 to 36 do fil[i,j]:=$00;
     clearbuf;
     inicio:=0;
     gotoxy (1,2);
     for i:=0 to 23 do dump ((inicio+i*16));
     while not salir do menu;
     textbackground (black);
     clrscr;
end.
